# Rebellion Mod
# By Jon 'Trip' Shafer - 05 Nov 2005
# Civilization 4 (c) 2005 Firaxis Games

# Have fun!

from CvPythonExtensions import *
import sys
import Popup as PyPopup
from PyHelpers import PyPlayer
import pickle
import CvEventManager
from PyHelpers import *
import CvUtil

# globals
gc = CyGlobalContext()
localText = CyTranslator()

DefaultUnitAI = UnitAITypes.NO_UNITAI

class CvRebellionMod(CvEventManager.CvEventManager):
	
	def __init__(self):
		
		self.CvEventManager = CvEventManager.CvEventManager
		
		self.CvEventManager.__init__(self)
#		CvEventManager.CvEventManager.__init__(self)
		
		####### System Variables #######
		
		# The City Script array IDs when loading/saving data
		self.iCitySpawnScriptID = 0
		
		####### Game Variables #######
		
		self.iBarbariansID = 18
		
		# Increase this value to make a Revolution more likely
		self.iRevolutionMod = 0#0
		# Chance of Rebel unit spawning near a city while the civ is in a Revolution
		self.iRebelSpawnRoll = 10000#10000
		# Range from cities rebel units can spawn
		self.iUnitSpawnRange = 2#2
		# Number of turns between when rebel units can spawn
		self.iCitySpawnUnitCounterMax = 6#6
		
		############## CITY VS STATE RELIGION ##############
		
		# Modifies how much a city having a different religion from the state affects chance of rebels
		self.iDifferentReligionFactor = 150 # Default is 150
		
		############## CIVICS ##############
				
		# Modifies how much a player's government civic option affects chance of rebels
		self.iDespotismFactor = 50 # Default is 50
		self.iHereditaryRuleFactor = 50 # Default is 50
		self.iPoliceStateFactor = 100 # Default is 100
		
		# Modifies how much a player's legal civic option affects chance of rebels
		self.iBarbarismFactor = 50 # Default is 50
		self.iVassalageFactor = 75 # Default is 75
		
		# Modifies how much a player's labor civic option affects chance of rebels
		self.iTribalismFactor = 50 # Default is 50
		self.iSlaveryFactor = 100 # Default is 100
		self.iSerfdomFactor = 100 # Default is 100
		self.iCasteSystemFactor = 85 # Default is 85
		
		# Modifies how much a player's religion civic option affects chance of rebels
		self.iPaganismFactor = 50 # Default is 50
		self.iOrganizedReligionFactor = 100 # Default is 100
		self.iTheocracyFactor = 100 # Default is 100
		
		############## LAND AREA ##############
		
		# Modifies how much a player's total amount of land affects chance of rebels
		self.iFactor = 100 # Default is 100
		
		############## HEALTH AND HAPPINESS ##############
		
		# Modifies how much a player's city unhealthiness affects chance of rebels
		self.iHealthFactor = 200 # Default is 200
		self.iHappinessFactor = 200 # Default is 200
		
		############## CITY NATIONALITY ##############
		
		self.iNationalityFactor = 1000 # Default is 1000
		
		############## CIV SIZE ##############
		
		# Modifies how much a player's total land area affects chance of rebels
		self.iCivSizeFactor = 1000 # Default is 1000
		
		############## ? ##############
		
		# Modifies how much a  affects chance of rebels
		self.iFactor = 100 # Default is 100
		
		self.szEventText = ""
		self.szResultText = ""
		
	def initValues(self):
		
		self.iWarriorID = CvUtil.findInfoTypeNum(gc.getUnitInfo, gc.getNumUnitInfos(), 'UNIT_WARRIOR')
		
	def turnChecker(self, iTurn):
		
		self.szGameDate = CyGameTextMgr().getTimeStr(iTurn, false)
		
		# Alter City Unit Spawning Counters
		self.alterCitySpawnUnitCounters()
		
		# Determine where rebels show up and whatnot
		self.doRebels(iTurn)
		
		# Check for Revolution
#		self.checkForRevolution(iTurn)
	
###########################################################################################
####################################### REBEL EVENTS ######################################
###########################################################################################
	
	def doRebels(self, iTurn):
		
		# Loop through all players...
		for iPlayerID in range(gc.getMAX_CIV_PLAYERS()):
			
			pPlayer = gc.getPlayer(iPlayerID)
#			pyPlayer = PyPlayer(iPlayerID)
			
			# If player is alive...
			if (pPlayer.isAlive()):
				
########################## This is where the fun begins ##########################
				
				# This player's state religion
				iStateReligionID = pPlayer.getStateReligion()
				
				# Civics
				iCivicsValue = self.getCivicsFactor(pPlayer)
				
				# Civ size in land plots
				iCivNumLandPlots = pPlayer.getTotalLand()
				
########################## Loop through player's cities... ##########################
				
				apCityList = self.getCityList(pPlayer)
				for pCity in apCityList:
					
					# City factors
					
					# City religions vs. state religion
					iReligionValue = self.getReligionFactor(iStateReligionID, pCity)
					# Make religion less important after the game is nearing completion
					iHalfTurnNum = (CyGame().getMaxTurns() - CyGame().getStartTurn()) / 2
					if (CyGame().getGameTurn() > iHalfTurnNum):
						iTurnsAfterHalf = CyGame().getGameTurn() - iHalfTurnNum
						fReligionMod = iTurnsAfterHalf / (iHalfTurnNum * 1.0)
						iReligionValue -= iReligionValue * fReligionMod
					
					# Health
					iHealthValue = (pCity.badHealth(false) - pCity.goodHealth()) * self.iHealthFactor
					if (iHealthValue < 0):
						iHealthValue = 0
					
					# Happiness
					iHappinessValue = (pCity.unhappyLevel(0) - pCity.happyLevel()) * self.iHappinessFactor
					if (iHappinessValue < 0):
						iHappinessValue = 0
					
					# City nationality
					iNationalityValue = (100 - pCity.calculateCulturePercent(iPlayerID)) * self.iNationalityFactor / 100
#					print("XXX - Player %d Culture Percent: %d; (100 - %d) * %d" %(iPlayerID, pCity.calculateCulturePercent(iPlayerID), pCity.calculateCulturePercent(iPlayerID), self.iNationalityFactor))
					
					# Civ size
					iCivSizeValue = iCivNumLandPlots / (CyMap().getLandPlots() * 1.0) * self.iCivSizeFactor
					
					# Sum all factors
					iTotalRebelValue = iReligionValue + iCivicsValue + iHealthValue + iHappinessValue + iNationalityValue + iCivSizeValue
					
					print("XXX - City %s has iTotalRebelValue of %d - Civics %d, Religion %d, Health %d, Happiness %d, Nationality %d, CivSize %d" %(pCity.getName(), iTotalRebelValue, iCivicsValue, iReligionValue, iHealthValue, iHappinessValue, iNationalityValue, iCivSizeValue))
					
					# Now spawn units
					self.checkForUnitSpawning(iPlayerID, pCity, iTotalRebelValue)
	
	def getReligionFactor(self, iStateReligionID, pCity):
		
		iReligionFactor = 0
		
		# Loop through all religions
		for iCityReligionID in range(gc.getNumReligionInfos()):
			
			# If city has this religion...
			if (pCity.isHasReligion(iCityReligionID)):
				
				# If this city religion doesn't match the state religion...
				if (iStateReligionID != iCityReligionID):
					
					iReligionFactor += self.iDifferentReligionFactor
		
		return iReligionFactor
	
	def getCivicsFactor(self, pPlayer):
		
		# Government Civics
		iCivicOptionGovernment = CvUtil.findInfoTypeNum(gc.getCivicOptionInfo, gc.getNumCivicOptionInfos(), 'CIVICOPTION_GOVERNMENT')
		iGovernmentCivic = pPlayer.getCivics(iCivicOptionGovernment)
		
		iDespotismID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_DESPOTISM')
		iHereditaryRuleID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_HEREDITARY_RULE')
		iPoliceStateID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_POLICE_STATE')
		
		# Legal Civics
		iCivicOptionLegal = CvUtil.findInfoTypeNum(gc.getCivicOptionInfo, gc.getNumCivicOptionInfos(), 'CIVICOPTION_LEGAL')
		iLegalCivic = pPlayer.getCivics(iCivicOptionLegal)
		
		iBarbarismID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_BARBARISM')
		iVassalageID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_VASSALAGE')
		
		# Labor Civics
		iCivicOptionLabor = CvUtil.findInfoTypeNum(gc.getCivicOptionInfo, gc.getNumCivicOptionInfos(), 'CIVICOPTION_LABOR')
		iLaborCivic = pPlayer.getCivics(iCivicOptionLabor)
		
		iTribalismID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_TRIBALISM')
		iSlaveryID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_SLAVERY')
		iSerfdomID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_SERFDOM')
		iCasteSystemID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_CASTE_SYSTEM')
		
		# Religion Civics
		iCivicOptionReligion = CvUtil.findInfoTypeNum(gc.getCivicOptionInfo, gc.getNumCivicOptionInfos(), 'CIVICOPTION_RELIGION')
		iReligionCivic = pPlayer.getCivics(iCivicOptionReligion)
		
		iPaganismID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_PAGANISM')
		iOrganizedReligionID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_ORGANIZED_RELIGION')
		iTheocracyID = CvUtil.findInfoTypeNum(gc.getCivicInfo, gc.getNumCivicInfos(), 'CIVIC_THEOCRACY')
		
		########## CALCULATE VALUES ##########
		
		iCivicValue = 0
		
		if (iGovernmentCivic == iDespotismID):
			iCivicValue += self.iDespotismFactor
		elif (iGovernmentCivic == iHereditaryRuleID):
			iCivicValue += self.iHereditaryRuleFactor
		elif (iGovernmentCivic == iPoliceStateID):
			iCivicValue += self.iPoliceStateFactor
			
		if (iLegalCivic == iBarbarismID):
			iCivicValue += self.iBarbarismFactor
		elif (iLegalCivic == iVassalageID):
			iCivicValue += self.iVassalageFactor
			
		if (iLaborCivic == iTribalismID):
			iCivicValue += self.iTribalismFactor
		elif (iLaborCivic == iSlaveryID):
			iCivicValue += self.iSlaveryFactor
		elif (iLaborCivic == iSerfdomID):
			iCivicValue += self.iSerfdomFactor
		elif (iLaborCivic == iCasteSystemID):
			iCivicValue += self.iCasteSystemFactor
			
		if (iReligionCivic == iPaganismID):
			iCivicValue += self.iPaganismFactor
		elif (iReligionCivic == iOrganizedReligionID):
			iCivicValue += self.iOrganizedReligionFactor
		elif (iReligionCivic == iTheocracyID):
			iCivicValue += self.iTheocracyFactor
		
		return iCivicValue
		
###########################################################################################
####################################### OTHER EVENTS ######################################
###########################################################################################
	
	def checkForRevolution(self, iTurn):
		
		# Factor between 1.0 and 2.0 making revolution more likely
		fRevolutionModifier = iTurn / (self.iMaxTurn * 1.0) * 2
		if (fRevolutionModifier < 1.0):
			fRevolutionModifier = 1.0
		
		# Loop through all players
		for iPlayerLoop in range(self.iNumPlayers):
			
			pPlayer = gc.getPlayer(iPlayerLoop)
			
			print("XXX - Player %d has lost %d Units" %(iPlayerLoop, self.getPlayerNumUnitsLost(iPlayerLoop)))
			
			if (pPlayer.isAlive()):
					
				if (self.isPlayerInRevolution(iPlayerLoop)):
					
					# Player is in Revolution, now make him PAY!
					self.checkForUnitSpawning(iPlayerLoop)
					
					# Okay, we're in Revolution, no need to check any further for this player
					continue
				
				iNumUnitsLost = self.getPlayerNumUnitsLost(iPlayerLoop)
				iTotalPopulation = pPlayer.getTotalPopulation()
				
				# Don't want dead people messing with stuff
				if (iTotalPopulation <= 0):
					return
					
				fRevolutionChance = iNumUnitsLost / (iTotalPopulation * 4.0) * fRevolutionModifier * 100 + self.iRevolutionMod
				iRoll = self.getRand(98) + 1# Measure to prevent a roll of 0
				
				print("XXX - Checking for Player %d revolution with fChance of %f and Rand of %d; %d UnitsLost and Pop of %d" %(iPlayerLoop, fRevolutionChance, iRoll, iNumUnitsLost, iTotalPopulation))
				
				# Check final factor against rand
				if (fRevolutionChance > iRoll):
					
					self.setPlayerInRevolution(iPlayerLoop, true)
					
					# Set event text
					if (iPlayerLoop == self.iRussiaID):
						self.szEventText = localText.getText("TXT_KEY_RebellionMod_EVENT_RUSSIAN_REVOLUTION_DESC", ())
					else:
						self.szEventText = localText.getText("TXT_KEY_RebellionMod_EVENT_GENERIC_REVOLUTION_DESC", ())
						
					self.szResultText = localText.getText("TXT_KEY_RebellionMod_EVENT_GENERIC_REVOLUTION_EFFECT", (pPlayer.getCivilizationShortDescription(0),))
					
					self.displayEventText()
					
	def checkForUnitSpawning(self, iPlayerID, pCity, iTotalRebelValue):
		
		iCityX = pCity.getX()
		iCityY = pCity.getY()
		
		# If this city has spawned a unit recently then no more units
		if (self.getCitySpawnUnitCounter(iPlayerID, pCity) == 0):
			
			iUnitSpawnRoll = self.getRand(self.iRebelSpawnRoll)
#			print("iUnitSpawnRoll: %d" %(iUnitSpawnRoll))
			# Create Warrior for the Barbarians
			if (iUnitSpawnRoll < iTotalRebelValue):
				
				aiSpawnPlot = self.findUnitPlacementPlot(self.iBarbariansID, iCityX, iCityY, true, true, self.iUnitSpawnRange)
#				print("Spawn Plot: %d, %d" %(aiSpawnPlot[0], aiSpawnPlot[1]))
				if (aiSpawnPlot == "Oh Snap"):
					return
				else:
					pBarbarians = gc.getPlayer(self.iBarbariansID)
					
					print("XXX - Roll: %d Player %d in revolution; Rebel spawning at [%d, %d]" %(iUnitSpawnRoll, iPlayerID, aiSpawnPlot[0], aiSpawnPlot[1]))
					pBarbarians.initUnit(self.iWarriorID, aiSpawnPlot[0], aiSpawnPlot[1], UnitAITypes.UNITAI_ATTACK)
					
					self.setCitySpawnUnitCounter(iPlayerID, pCity, self.iCitySpawnUnitCounterMax)
		
	def alterCitySpawnUnitCounters(self):
		
		# Loop through all players...
		for iPlayerLoop in range(gc.getMAX_CIV_PLAYERS()):
			
			pPlayer = gc.getPlayer(iPlayerLoop)
			
			# If this player is alive...
			if (pPlayer.isAlive()):
				
				apCityList = self.getCityList(pPlayer)
				
				# Loop through all this player's cities...
				for pCity in apCityList:
					
					iCityID = pCity.getID()
					# If this city's spawn counter is greater than 0...
					if (self.getCitySpawnUnitCounter(iPlayerLoop, pCity) > 0):
						# Reduce CitySpawnUnit counter by 1 in applicable cities
						self.changeCitySpawnUnitCounter(iPlayerLoop, iCityID, -1)
					
###########################################################################################
#################################### UTILITY FUNCTIONS ####################################
###########################################################################################
		
	def getRand(self, iNum):
		
		return CyGame().getSorenRandNum(iNum, "RebellionModScenario")
		
	def findUnitPlacementPlot(self, iPlayerID, iPlotX, iPlotY, bLand = true, bIncludePlot = true, iRange = 3):
		
		aTHEPlot = []
		aiPossiblePlots = []
		iNumPossiblePlots = 0
		aiTempPlotHolder = []
		
		pThisPlayer = gc.getPlayer(iPlayerID)
		pThisTeam = gc.getTeam(pThisPlayer.getTeam())
		
		# Loop through plots in usable range
		for iXLoop in range(iPlotX - iRange, iPlotX + iRange):
			for iYLoop in range(iPlotY - iRange, iPlotY + iRange):
				
				# Map bounds
				if (iXLoop >= 0 and iXLoop < CyMap().getGridWidth() and iYLoop >= 0 and iYLoop < CyMap().getGridHeight()):
					
					# Check to see if center plot should be excluded
					if (bIncludePlot or (not bIncludePlot and (iXLoop != iPlotX) and (iYLoop != iPlotY))):
						
						pPlot = CyMap().plot(iXLoop, iYLoop)
						
						# Don't include enemy city plots!
						if (pPlot.isEnemyCity(pThisPlayer.getTeam()) == false):
							
							# Passable?
							if (not pPlot.isImpassable()):
								
								# Check whether this plot type matches the type requested
								if ((bLand == true and CyMap().plot(iXLoop, iYLoop).isWater() == false) or \
								    (bLand == false and CyMap().plot(iXLoop, iYLoop).isWater() == true)):
									aiTempPlotHolder = [iXLoop, iYLoop]
									aiPossiblePlots.append(aiTempPlotHolder)
									iNumPossiblePlots += 1
					
		if (iNumPossiblePlots == 0):
			return "Oh Snap"
		
		# Now that our list of possible plots is made, we pick one of them randomly and shove aside any enemy units already there
		iChosenPlot = self.getRand(iNumPossiblePlots - 1)
		aTHEPlot = aiPossiblePlots[iChosenPlot]
		
		# Check to see if there are any other units already on this plot
		pPlot = CyMap().plot(aTHEPlot[0], aTHEPlot[1])
		
		if (pPlot.getNumUnits() > 0):
			
			bEnemiesPresent = true
			
			while(pPlot.getNumUnits() > 0 and bEnemiesPresent):
				pLoopUnit = pPlot.getUnit(0)
				pUnitOwner = gc.getPlayer(pLoopUnit.getOwner())
				
				if (pUnitOwner):
					# Check to see if this unit belongs to a player that 'our' player is at war with
					if (pThisTeam.isAtWar(pUnitOwner.getTeam())):
						# Move this enemy unit
						self.moveUnitAside(pLoopUnit)
					else:
						# If it's a friendly, don't move it!
						bEnemiesPresent = false
		
		return aTHEPlot
		
	def moveUnitAside(self, pUnitToMove):
		
		iUnitX = pUnitToMove.getX()
		iUnitY = pUnitToMove.getY()
		
		# Don't look further than 10 plots away
		iMaxRange = 10
		iRing = 1
		
		aaiTestedList = [iUnitX, iUnitY]
		
		pPlayer = gc.getPlayer(pUnitToMove.getOwner())
		pTeam = gc.getTeam(pPlayer.getTeam())
		
		# Loop in rings around the unit's plot until we find another plot to move this unit to
		while (iRing < iMaxRange):
			
			aiTempList = []
			aaiToTestList = []
			iNumToTest = 0
			aaiValidPlotList = []
			iNumValid = 0
			
			# Find plots in this ring range
			for iX in range(-iRing, iRing + 1):
				for iY in range(-iRing, iRing + 1):
					aiTempList = [iX + iUnitX, iY + iUnitY]
					
					# Don't test this plot more than once
					if (aiTempList not in aaiTestedList):
						
						pPlot = CyMap().plot(aiTempList[0], aiTempList[1])
						bValidPlot = false
						
						if (pPlot.isWater() and pUnitToMove.getDomainType() == DomainTypes.DOMAIN_SEA):
							bValidPlot = true
						elif (pPlot.isWater() == false):
							if (pUnitToMove.getDomainType() == DomainTypes.DOMAIN_LAND or pUnitToMove.getDomainType() == DomainTypes.DOMAIN_AIR):
								bValidPlot = true
						
						# Make sure this unit can move to this plot type (no land units on water, etc.)
						if (bValidPlot):
							aaiToTestList.append(aiTempList)
							iNumToTest += 1
					
			# Now test these plots
			for iTestLoop in range(iNumToTest):
				
				pPlot = CyMap().plot(iUnitX, iUnitY)
				
				iX = aaiToTestList[iTestLoop][0]
				iY = aaiToTestList[iTestLoop][1]
				
				# If there are no enemy units here then add to the final valid plot list
				if (not self.isEnemyUnits(pTeam, iX, iY)):
					
					aaiValidPlotList.append(aaiToTestList[iTestLoop])
					iNumValid += 1
					
				# Add this plot to the tested list (to prevent it being looked at again) and look at the next in this ring
				aaiTestedList.append(aaiToTestList[iTestLoop])
				
			# This ring has been iterated through and placed in a final list - now pick a random plot from that list and exit the function
			
			if (iNumValid > 0):
				iChosenPlot = self.getRand(iNumValid - 1)
				
				iX = aaiValidPlotList[iChosenPlot][0]
				iY = aaiValidPlotList[iChosenPlot][1]
				
				pUnitToMove.setXY(iX, iY)
				
				return
				
			# None of the plots in this ring are valid, so time to try the next ring
			
			iRing += 1
		
	def isEnemyUnits(self, pThisTeam, iPlotX, iPlotY):
		
		# Check to see if there are any other units already on this plot
		pPlot = CyMap().plot(iPlotX, iPlotY)
		
		if (pPlot.getNumUnits() > 0):
			
			for iUnitLoop in range(pPlot.getNumUnits()):
				
				pLoopUnit = pPlot.getUnit(iUnitLoop)
				
				pUnitOwner = gc.getPlayer(pLoopUnit.getOwner())
				
				# Check to see if this unit belongs to a player that 'our' player is at war with
				if (pThisTeam.isAtWar(pUnitOwner.getTeam())):
					return true
		
		return false
	
	def getCityList(self, pPlayer):
		iPlayerID = pPlayer.getID()
		
		lCity = []
		(loopCity, iter) = pPlayer.firstCity(false)
		while(loopCity):
			cityOwner = loopCity.getOwner()
			if ( not loopCity.isNone() and loopCity.getOwner() == iPlayerID ): #only valid cities
				pCity = pPlayer.getCity(loopCity.getID())
#				city = PyCity( self.getID(), loopCity.getID() )
				lCity.append(pCity)
			(loopCity, iter) = pPlayer.nextCity(iter, false)
		return lCity
		
	def addPopup(self, szText, szTitle):
		
#		szTitle = self.szGameDate = CyGameTextMgr().getTimeStr(CyGame().getGameTurn(), false)
		
		popup = PyPopup.PyPopup(-1)
		popup.setHeaderString(szTitle)
		popup.setBodyString(szText)
		popup.launch(true, PopupStates.POPUPSTATE_QUEUED)
		
###########################################################################################
####################################### SCRIPT DATA #######################################
###########################################################################################
	
	def initCity(self, pCity):
		
		# Parameter 0 is City Spawn Unit Counter Max
		szScriptData = [self.iCitySpawnUnitCounterMax]
		
		# Save Script Data - SpawnUnitCounter
		pCity.setScriptData(pickle.dumps(szScriptData))
	
	def getCitySpawnUnitCounter(self, iPlayer, pCity):
		
		pPlayer = gc.getPlayer(iPlayer)
#		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - SpawnUnitCounter
		szScriptData = pickle.loads(pCity.getScriptData())
		iSpawnUnitCounter = szScriptData[self.iCitySpawnScriptID]
		
		return iSpawnUnitCounter
		
	def setCitySpawnUnitCounter(self, iPlayer, pCity, iValue):
		
		pPlayer = gc.getPlayer(iPlayer)
#		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - SpawnUnitCounter
		szScriptData = pickle.loads(pCity.getScriptData())
		
		# Save Script Data - SpawnUnitCounter
		szScriptData[self.iCitySpawnScriptID] = iValue
		pCity.setScriptData(pickle.dumps(szScriptData))
		
	def changeCitySpawnUnitCounter(self, iPlayer, iCity, iChange):
		
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - SpawnUnitCounter
		szScriptData = pickle.loads(pCity.getScriptData())
		iSpawnUnitCounter = szScriptData[self.iCitySpawnScriptID]
		
		iSpawnUnitCounter += iChange
		
		# Save Script Data - SpawnUnitCounter
		szScriptData[self.iCitySpawnScriptID] = iSpawnUnitCounter
		pCity.setScriptData(pickle.dumps(szScriptData))
		
###########################################################################################
##################################### EVENT OVERRIDES #####################################
###########################################################################################
	
	def onGameStart(self, argsList):
		'Called at the start of the game'
		
		# Set up mod-specific values
		self.initValues()
		
		self.CvEventManager.onGameStart(self, argsList)
	
	def onLoadGame(self, argsList):
		'Called when game is loaded'
		
		# Set up mod-specific values
		self.initValues()
		
		self.CvEventManager.onLoadGame(self, argsList)

	def onEndGameTurn(self, argsList):
		'Called at the end of the end of each turn'
		iGameTurn = argsList[0]
		
		# Everything that happens at the end of a turn pertaining to the mod comes through here
		self.turnChecker(iGameTurn)
		
		self.CvEventManager.onEndGameTurn(self, argsList)
		
	def onCityBuilt(self, argsList):
		'City Built'
		city = argsList[0]
		
		# Init city script data (unit spawn counter)
		self.initCity(city)
		
		self.CvEventManager.onCityBuilt(self, argsList)
		
	def onCityAcquired(self, argsList):
		'City Acquired'
		
		owner,playerType,city,bConquest,bTrade = argsList
		
		# Init city script data (unit spawn counter)
		self.initCity(city)
		
		self.CvEventManager.onCityAcquired(self, argsList)
	
